/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.TagInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantWitherSkeletonBodyPart
extends Entity
implements IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<Integer> PART = SynchedEntityData.m_135353_(MutantWitherSkeletonBodyPart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public boolean yawPositive;
    public boolean pitchPositive;
    public int lifeTime;
    public boolean glows = false;
    public float damage = 0.0f;
    public int witherLength = 0;
    public int witherLevel = 0;
    public int despawnTime = 6000;

    public MutantWitherSkeletonBodyPart(EntityType<? extends MutantWitherSkeletonBodyPart> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.f_19860_ = this.f_19796_.m_188501_() * 360.0f;
        this.f_19859_ = this.f_19796_.m_188501_() * 360.0f;
        this.yawPositive = this.f_19796_.m_188499_();
        this.pitchPositive = this.f_19796_.m_188499_();
    }

    protected MutantWitherSkeletonBodyPart(Level world, Mob owner, int part) {
        this((EntityType<? extends MutantWitherSkeletonBodyPart>)((EntityType)EntityTypeInit.MUTANT_WITHER_SKELETON_BODY_PART.get()), world);
        this.setPart(part);
        this.m_6027_(owner.m_20185_(), owner.m_20186_() + (double)(3.2f * (0.25f + this.f_19796_.m_188501_() * 0.5f)), owner.m_20189_());
        this.m_7311_(owner.m_20094_());
    }

    public boolean m_142038_() {
        return this.glows || (Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_parts_glow_on.get() != false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PART, (Object)0);
    }

    public int getPart() {
        return (Integer)this.f_19804_.m_135370_(PART);
    }

    private void setPart(int part) {
        this.f_19804_.m_135381_(PART, (Object)part);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.getItemByPart());
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_()) {
            this.m_20334_(0.0, 0.05, 0.0);
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.045, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.96));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.7));
        }
        if (!this.f_19861_ && this.f_19865_ == Vec3.f_82478_) {
            this.m_146926_(this.f_19860_ += 10.0f * (float)(this.yawPositive ? 1 : -1));
            this.m_146922_(this.f_19859_ += 15.0f * (float)(this.pitchPositive ? 1 : -1));
            if (!this.f_19853_.f_46443_) {
                for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this::canHarm)) {
                    entity.m_7311_(this.m_20094_() / 20);
                    entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this), this.damage);
                    if (!(entity instanceof LivingEntity)) continue;
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, this.witherLength, this.witherLevel));
                }
            }
        }
        if (!this.f_19861_ && !this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 10, 0.0075f, this.m_20183_(), 5, CameraShakePriority.EFFECT);
        }
        ++this.lifeTime;
        if (!this.f_19853_.f_46443_ && this.lifeTime >= this.despawnTime) {
            this.m_146870_();
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_6084_()) {
            if (!this.f_19853_.f_46443_) {
                this.m_19998_((ItemLike)this.getItemByPart()).m_32061_();
                this.m_146870_();
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    private boolean canHarm(Entity entity) {
        return !entity.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_CANT_HURT);
    }

    public Item getItemByPart() {
        int part = this.getPart();
        if (part == 0) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_PELVIS.get();
        }
        if (part == 1) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_RIB.get();
        }
        if (part == 2) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_SKULL.get();
        }
        if (part == 3) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_LIMB.get();
        }
        if (part == 4) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_SHOULDER_PAD.get();
        }
        return (Item)ItemInit.MUTANT_WITHER_SKELETON_PELVIS.get();
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Part", this.getPart());
        tag.m_128379_("Glows", this.glows);
        tag.m_128350_("Damage", this.damage);
        tag.m_128405_("WitherLength", this.witherLength);
        tag.m_128405_("WitherLevel", this.witherLevel);
        tag.m_128405_("DespawnTime", this.despawnTime);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setPart(tag.m_128451_("Part"));
        this.glows = tag.m_128471_("Glows");
        this.damage = tag.m_128457_("Damage");
        this.witherLength = tag.m_128451_("WitherLength");
        this.witherLevel = tag.m_128451_("WitherLevel");
        this.despawnTime = tag.m_128451_("DespawnTime");
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

